local showAFTs = true
if not string.find(string.lower(PREFSMAN:GetPreference('VideoRenderers')), 'opengl')
or string.find(string.lower(PREFSMAN:GetPreference('VideoRenderers')), 'd3d')
and string.find(string.lower(PREFSMAN:GetPreference('VideoRenderers')), 'opengl') 
and string.find(string.lower(PREFSMAN:GetPreference('VideoRenderers')), 'd3d') < 
string.find(string.lower(PREFSMAN:GetPreference('VideoRenderers')), 'opengl') then
	showAFTs = false
end

local sw = SCREEN_WIDTH
local sh = SCREEN_HEIGHT
local scx = SCREEN_CENTER_X
local scy = SCREEN_CENTER_Y
local dw = PREFSMAN:GetPreference('DisplayWidth')
local dh = PREFSMAN:GetPreference('DisplayHeight')
local zr = sw/dw
local rz = dw/sw
local hstripCount = 72
local hstripHeight = dh / hstripCount
local vstripCount = math.ceil(hstripCount * sw / sh - 0.5)
local vstripWidth = dw / vstripCount
local hsliceCount = 2
local hstrips = {}
local vstrips = {}
local vstripFrames = {}
local hslicesR = {}
local hslicesC = {}
local aft_screenTex,aft_hStripsTex,aft_vStripsTex
local comboProxies = {}
local rCols = { { 0, 0, 0, 0, 0, 0, 0, 0 }, { 0, 0, 0, 0, 0, 0, 0, 0 } }
local styleName = GAMESTATE:GetCurrentStyle():GetName()
local centerCol = styleName == 'double' and 4.5 or 2.5

local checked = false

-- EASING --
local path = GAMESTATE:GetCurrentSong():GetSongDir()..'lua/'
loadfile(path..'easing.lua')()
loadfile(path..'modhelpers.lua')()
loadfile(path.."mods.lua")()

local function Plr(pn)
	if GAMESTATE:IsPlayerEnabled(pn-1) then
		return SCREENMAN:GetTopScreen():GetChild('PlayerP'..pn)
	else
		return nil
	end
end
function GetJud(pn)
	return _G['jud'..pn]
end
function GetCom(pn)
	return _G['com'..pn]
end

function mod_do(str,pn)
	if pn then
		if GAMESTATE:IsPlayerEnabled(pn-1) then
			taronuke_mods(str,pn)
		end
	else
		for pn=1,2 do
			if GAMESTATE:IsPlayerEnabled(pn-1) then
				taronuke_mods(str,pn)
			end
		end
	end
end

-- ALIASES --
--These make it so the syntax for the table entries matches the syntax for the nITG template.
--If you want to prefix all your calls with "modhelpers.", "ease.", etc., then you won't need this and can remove this section.
local linear, inQuad, outQuad, inOutQuad, outInQuad, inCubic, outCubic, inOutCubic, outInCubic, inQuart,outQuart, inOutQuart, outInQuart, inQuint, outQuint, inOutQuint, outInQuint, inSine, outSine, inOutSine,outInSine, inExpo, outExpo, inOutExpo, outInExpo, inCirc, outCirc, inOutCirc, outInCirc, inElastic,outElastic, inOutElastic, outInElastic, inBack, outBack, inOutBack, outInBack, inBounce, outBounce,inOutBounce, outInBounce = ease.linear, ease.inQuad, ease.outQuad, ease.inOutQuad, ease.outInQuad,ease.inCubic, ease.outCubic, ease.inOutCubic, ease.outInCubic, ease.inQuart, ease.outQuart,ease.inOutQuart, ease.outInQuart, ease.inQuint, ease.outQuint, ease.inOutQuint, ease.outInQuint,ease.inSine, ease.outSine, ease.inOutSine, ease.outInSine, ease.inExpo, ease.outExpo, ease.inOutExpo,ease.outInExpo, ease.inCirc, ease.outCirc, ease.inOutCirc, ease.outInCirc, ease.inElastic,ease.outElastic, ease.inOutElastic, ease.outInElastic, ease.inBack, ease.outBack, ease.inOutBack,ease.outInBack, ease.inBounce, ease.outBounce, ease.inOutBounce, ease.outInBounce

local perframe, mod_insert, mod2_insert, mod_ease, mod_perframe, mod_message, mod_blacklist, simple_m0d, simple_m0d2, simple_m0d3, mod_wiggle, mod_spring, mod_springt, mod_springt2, mod_spring_adjustable, mod_onebeat, switcfino_add, switcfino_reset, mod_sugarkiller, modulo, reverseRotation, randomXD, mod_bounce, ease_wiggle, ease_wiggleAbs = modhelpers.perframe, modhelpers.mod_insert, modhelpers.mod2_insert, modhelpers.mod_ease, modhelpers.mod_perframe, modhelpers.mod_message, modhelpers.mod_blacklist, modhelpers.simple_m0d, modhelpers.simple_m0d2, modhelpers.simple_m0d3, modhelpers.mod_wiggle, modhelpers.mod_spring, modhelpers.mod_springt, modhelpers.mod_springt2, modhelpers.mod_spring_adjustable, modhelpers.mod_onebeat, modhelpers.switcfino_add, modhelpers.switcfino_reset, modhelpers.mod_sugarkiller, modhelpers.modulo,modhelpers.reverseRotation, modhelpers.randomXD, modhelpers.mod_bounce, modhelpers.ease_wiggle, modhelpers.ease_wiggleAbs

local m = mod_insert
local m2 = mod_message
local me = mod_ease
local mb = mod_bounce
			
local l = 'len'
local e = 'end'



init_modsp1 = ''
init_modsp2 = ''

mod_plr = {}

mod_firstSeenBeat = GAMESTATE:GetSongBeat() --necessary to prevent long freezes


local diffName = {}
local poptions = {GAMESTATE:GetPlayerState(0):GetPlayerOptions('ModsLevel_Song'), GAMESTATE:GetPlayerState(1):GetPlayerOptions('ModsLevel_Song')}
local playerscrolldir = {}
local playerspeed = {}
local playermini = {}
local playerminisize = {}
local playermirror = {}
local soptions = GAMESTATE:GetSongOptions('ModsLevel_Song')
local rate = 1
local xmu,sic = string.find(soptions,'xMusic')
if xmu then
	local begin = xmu-1
	while begin > 0 and string.match(string.sub(soptions,begin,begin),'[.%d]') do
		begin = begin - 1
	end
	local rateString = string.sub(soptions, begin + 1, xmu - 1)
	rate = tonumber(rateString)
end
local bpm = 124 * rate
for pn = 1,2 do
	if GAMESTATE:IsPlayerEnabled(pn-1) then
		diffName[pn] = GAMESTATE:GetCurrentSteps(pn-1):GetDifficulty()
		if poptions[pn] then
			playerscrolldir[pn] = (poptions[pn]:Reverse() == 0 and 1 or -1)
			playermirror[pn] = poptions[pn]:Mirror()
			playermini[pn] = poptions[pn]:Mini() * 100
			playerminisize[pn] = (200-playermini[pn])/200
			
			local xm = poptions[pn]:XMod()
			local cm = poptions[pn]:CMod()
			local mm = poptions[pn]:MMod()
			if mm then cm = mm end
			if cm then
				playerspeed[pn] = cm / bpm
			else
				playerspeed[pn] = xm
			end
		end
	end
end

local pp = {}


---------------------------------------------------------------------------------------
----------------------Begin tables 'n stuff--------------------------------------------
---------------------------------------------------------------------------------------

--beat based mods
--{beat_start, beat_end, mods, len_or_end, player_number}
mods = {
	{0,9999,'*1000 overhead, *1000 no beat, *1000 no drunk, *1000 no tipsy, *1000 no invert, *1000 no flip, *1000 no split, *1000 no alternate, *1000 no cross, *1000 no dizzy','end'},
	playerspeed[1] and {0,9999,'*1000000 '..playerspeed[1]..'x','end',1} or nil,
	playerspeed[2] and {0,9999,'*1000000 '..playerspeed[2]..'x','end',2} or nil,
}
			
--this is both a message broadcaster and a function runner
--if you put {beat,'String'}, then 'String' is broadcast as a message on that beat
--if you put {beat,function() somecode end}, then function() is run at that beat
--see example on beat 32

curaction = 1
--{beat,thing,persists}
mod_actions = {


	
}
			
--beat-based ease mods
--{time_start, time_end, mod_start, mod_end, mod, len_or_end, ease_type, player_number, sustaintime, optional_param1, optional_param2}
--valid ease types are:
	--linear
	--inQuad    outQuad    inOutQuad    outInQuad
	--inCubic   outCubic   inOutCubic   outInCubic
	--inQuart   outQuart   inOutQuart   outInQuart
	--inQuint   outQuint   inOutQuint   outInQuint
	--inSine    outSine    inOutSine    outInSine
	--inExpo    outExpo    inOutExpo    outInExpo
	--inCirc    outCirc    inOutCirc    outInCirc
	--inElastic outElastic inOutElastic outInElastic    --can take 2 optional parameters - amplitude & period
	--inBack    outBack    inOutBack    outInBack       --can take 1 optional parameter  - spring amount
	--inBounce  outBounce  inOutBounce  outInBounce
	
mods_ease = {
	-- EXAMPLE TWEEN: from beat 0 to 4, make rotationz go from 360 to 0 with the inOutBack tween
	--{0,4,360,0,'rotationz','end',inOutBack},
}



mod_perframes = {
	
}

function mpf(s,e,f)
	table.insert(mod_perframes,{s,e,f})
end

local vwaves = {}
local hwaves = {}
local slicePositions = {}
local values = { vwaveBeatOffset = 0, hwaveBeatOffset = 0, sliceBeatOffset = 0, baseArrowSize = 1 }

local function calcVWave(intensity)
	local offsetBeat = GAMESTATE:GetSongBeat() + values.vwaveBeatOffset
	vwaves = {}
	if intensity ~= 0 then
		vwaves[1] = {
			amplitude = intensity * (math.sin(offsetBeat*0.123)*.234+.456),
			frequency = math.sin(offsetBeat*.012)*.132+.243,
			offset = math.sin(offsetBeat*.201)*.097 + offsetBeat*.345,
		}
		vwaves[2] = {
			amplitude = intensity * (math.sin(offsetBeat*0.135)*.246+.468),
			frequency = math.sin(offsetBeat*.018)*.089+.147,
			offset = math.sin(offsetBeat*.165)*.141 + offsetBeat*.357,
		}
	end
end
local function calcHWave(intensity)
	local offsetBeat = GAMESTATE:GetSongBeat() + values.hwaveBeatOffset
	hwaves = {}
	if intensity ~= 0 then
		hwaves[1] = {
			amplitude = intensity * (math.sin(offsetBeat*0.321)*.432+.654),
			frequency = math.sin(offsetBeat*.021)*.312+.423,
			offset = math.sin(offsetBeat*.201)*.097 + offsetBeat*.543,
		}
		hwaves[2] = {
			amplitude = intensity * (math.sin(offsetBeat*0.531)*.642+.864),
			frequency = math.sin(offsetBeat*.081)*.098+.417,
			offset = math.sin(offsetBeat*.215)*.411 + offsetBeat*.753,
		}
	end
end
local function calcSlices(intensity)
	local offsetBeat = GAMESTATE:GetSongBeat() + values.sliceBeatOffset
	slicePositions = {}
	if intensity ~= 0 then
		local tx = math.sin(offsetBeat*0.03649) * 0.05
		slicePositions[1] = {
			y = math.sin(offsetBeat*0.0149) * 0.45 + 0.5,
			hh = math.sin(offsetBeat*0.01625) * 0.05 + 0.075,
			xr = (math.sin(offsetBeat*0.06481) * 0.1 + tx) * intensity,
			xc = (math.sin(offsetBeat*0.100121) * 0.1 + tx) * intensity,
		}
		local tx = math.sin(offsetBeat*0.144) * 0.05
		slicePositions[2] = {
			y = math.sin(offsetBeat*0.0169) * 0.6 + 0.5,
			hh = math.sin(offsetBeat*0.0196) * 0.05 + 0.075,
			xr = (math.sin(offsetBeat*0.0225) * 0.1 + tx) * intensity,
			xc = (math.sin(offsetBeat*0.0256) * 0.1 + tx) * intensity,
		}
	end
end

local function addValue(name, value)
	local name = name
	local value = value
	return function()
		values[name] = values[name] + value
	end
end
local function setValue(name)
	local name = name
	return function(value)
		values[name] = value
	end
end

local function justTheScratch(beat)
	me(beat-.25,.25,0,2,calcVWave,l,inQuad)
	me(beat,.5,2,0,calcVWave,l,outElastic,nil,1,3,7)
	me(beat,.25,0,2,calcHWave,l,inQuad)
	me(beat+.25,.25,2,0,calcHWave,l,outQuad,nil,1)
	
	m2(beat+.5,addValue('vwaveBeatOffset',130))
	m2(beat+.5,addValue('hwaveBeatOffset',130))
end	

local function scratchAlarm(beat)
	justTheScratch(beat)

	me(beat+.25,.25,0,1,calcSlices,l,inQuad)
	me(beat+.5,.5,1,0,calcSlices,l,inQuad)
	
	m2(beat+.75,addValue('sliceBeatOffset',130))
	m2(beat+1,addValue('sliceBeatOffset',130))
	
	me(beat+1,.25,0,1,calcSlices,l,inQuad)
	me(beat+1.25,.5,1,0,calcSlices,l,inQuad,nil,1)
	
	m2(beat+1.5,addValue('sliceBeatOffset',130))
	m2(beat+2,addValue('sliceBeatOffset',130))
end

local function bigMini(beat,duration,intensity)
	for pn = 1,2 do
		if playermini[pn] then
			me(beat,duration,-200*intensity+playermini[pn]*(1+intensity),playermini[pn],'mini',l,outQuad,pn)
			me(beat,duration,playerspeed[pn]/(1+intensity),playerspeed[pn],'xmod',l,outQuad,pn)
			me(beat,duration,50*intensity,0,'flip',l,outQuad,pn)
		end
	end
end

local function whiteNoise(beat,duration,intensity)
	me(beat,duration,intensity,0,calcSlices,l,outQuad)
	m2(beat+duration,addValue('sliceBeatOffset',130))
end

-- smork was here.

local function spin(pn)
	local pnt = pn and { pn } or { 1, 2 }
	return function(amount)
		for _,pn in ipairs(pnt) do
			local plr = SCREENMAN:GetTopScreen():GetChild('PlayerP'..pn)
			if plr then
				local nf = plr:GetChild('NoteField')
				for col = 1,8 do
					local ca = nf:GetColumnActors()[col]
					if ca then
						ca:GetRotHandler():SetSplineMode('NoteColumnSplineMode_Offset')
						ca:GetRotHandler():SetBeatsPerT(1)
						local spl = ca:GetRotHandler():GetSpline()
						spl:SetSize(1)
						spl:SetPoint(1,{0,0,amount} )
						spl:Solve()
					end
				end
			end
		end
	end
end
local function noSpin()
	for pn=1,2 do
		local plr = SCREENMAN:GetTopScreen():GetChild('PlayerP'..pn)
		if plr then
			local nf = plr:GetChild('NoteField')
			for col = 1,8 do
				local ca = nf:GetColumnActors()[col]
				if ca then
					ca:GetRotHandler():SetSplineMode('NoteColumnSplineMode_Disabled')
				end
			end
		end
	end
end

local function highlightLine(startTime,length,startStrength,endStrength,easeType,sustainTime)
	me(startTime,length,-startStrength,-endStrength,'sudden',l,easeType,nil,sustainTime)
	me(startTime,length,-startStrength,-endStrength,'hidden',l,easeType,nil,sustainTime)
	me(startTime,length,startStrength,endStrength,'stealth',l,easeType,nil,sustainTime)
end

scratchAlarm(14)
for beat = 16,45 do
	bigMini(beat,1,.2)
end
for beat = 33,45,2 do
	whiteNoise(beat,.5,.5)
end
scratchAlarm(46)
for beat = 48,77 do
	bigMini(beat,1,.2)
end
for beat = 49,77,2 do
	whiteNoise(beat,.5,.5)
end
for beat = 48,77 do
	me(beat,.5,0,-40,'boost',l,inQuad)
	me(beat+.5,.5,-40,0,'boost',l,outQuad)
end
scratchAlarm(78)

me(80,104,0,100,'drunk',e,inQuad)
me(80,104,0,100,'tipsy',e,inQuad)
me(80,104,0,.5,calcVWave,e,outQuad)
me(80,104,0,.5,calcHWave,e,outQuad)

whiteNoise(81,.9,1)
whiteNoise(83,.85,1)
whiteNoise(85,.8,1)
whiteNoise(87,.75,1)
whiteNoise(89,.7,1)
whiteNoise(91,.65,1)
whiteNoise(93,.6,1)
whiteNoise(95,.55,1)
whiteNoise(97,.5,1)
whiteNoise(99,.45,1)
whiteNoise(101,.4,1)
whiteNoise(103,.35,1)

me(104,110,100,0,'tipsy',e,outQuad)
me(104,110,.5,0,calcVWave,e,inQuad)
me(104,110,.5,0,calcHWave,e,inQuad)
local flipflop = 50
for beat = 104,109+1/3,2/3 do
	me(beat-1/3,1/3,beat == 104 and 100 or 0,flipflop,'drunk',l,inQuad)
	me(beat,1/3,flipflop,0,'drunk',l,outQuad)
	me(beat,1/3,0,20,'tornado',l,inQuad)
	me(beat+1/3,1/3,20,0,'tornado',l,outQuad)
	flipflop = -flipflop
end
if styleName == 'double' then
	me(104,105.5,0,math.pi *0.25,spin(),e,inOutCubic)
	me(105.5,108.5,math.pi *0.25,math.pi *-0.25,spin(),e,inOutQuad)
	me(108.5,110,math.pi *-0.25,0,spin(),e,inOutCubic)
else
	for pn = 1,2 do
		if diffName[pn] == 'Difficulty_Beginner' then
			me(104,105.5,0,math.pi *0.25,spin(pn),e,inOutSine)
			me(105.5,108.5,math.pi *0.25,math.pi *-0.25,spin(pn),e,inOutSine)
			me(108.5,110,math.pi *-0.25,0,spin(pn),e,inOutSine)
		else
			me(104,107,0,math.pi,spin(pn),e,inCubic)
			me(107,110,math.pi,2*math.pi,spin(pn),e,outCubic)
		end
	end
end
m2(110,noSpin)
scratchAlarm(110)

for beat = 112,172,4 do
	me(beat,0.75,1.3,1,setValue('baseArrowSize'),l,outQuad)
	me(beat+0.75,0.75,1.3,1,setValue('baseArrowSize'),l,outQuad,nil,0.5)
	if beat ~= 140 then
		me(beat+2,0.75,1.3,1,setValue('baseArrowSize'),l,outQuad)
		if beat == 124 or beat == 156 then
			me(beat+2.75,0.5,1.3,1,setValue('baseArrowSize'),l,outQuad)
			me(beat+3.25,0.25,1,2.5,setValue('baseArrowSize'),l,inQuad)
			me(beat+3.5,0.5,2.5,1,setValue('baseArrowSize'),l,outQuad)
		else
			me(beat+2.75,0.75,1.3,1,setValue('baseArrowSize'),l,outQuad)
			me(beat+3.5,0.5,1.3,1,setValue('baseArrowSize'),l,outQuad)
		end
	end
end
for beat = 113,173,2 do
	if beat ~= 127 and beat ~= 143 and beat ~= 159 then
		whiteNoise(beat,.5,1)
	end
end
for beat = 115,171,8 do
	highlightLine(beat-.25,.25,0,50,inQuad,.25)
	highlightLine(beat+.25,.25,50,0,inQuad)
	m(beat+.25,beat+.5,'*1000 100 hiddenoffset, *1000 100 suddenoffset',e)
	highlightLine(beat+.5,.25,0,50,inQuad)
	m(beat+.5,beat+1,'*1000 -50 hiddenoffset, *1000 -50 suddenoffset',e)
	highlightLine(beat+.75,.25,50,0,inQuad,.25)
	m(beat+1,beat+1.75,'*1000 50 hiddenoffset, *1000 50 suddenoffset',e)
	highlightLine(beat+1.25,.25,0,50,inQuad,.25)
	highlightLine(beat+1.75,.25,50,0,inQuad,.25)
	m(beat+1.75,beat+2,'*1000 0 hiddenoffset, *1000 0 suddenoffset',e)
	highlightLine(beat+2,.25,0,50,inQuad,.5)
	m(beat+2,beat+2.5,'*1000 100 hiddenoffset, *1000 100 suddenoffset',e)
	m(beat+2.5,beat+2.75,'*1000 -50 hiddenoffset, *1000 -50 suddenoffset',e)
	highlightLine(beat+2.75,.25,50,0,inQuad)
	m(beat+2.75,beat+3,'*1000 50 hiddenoffset, *1000 50 suddenoffset',e)
	if math.mod(beat,32) ~= 11 then
		highlightLine(beat+3,.25,0,50,inQuad,.25)
		m(beat+3,beat+3.5,'*1000 0 hiddenoffset, *1000 0 suddenoffset',e)
		highlightLine(beat+3.5,.25,50,0,inQuad)
		m(beat+3.5,beat+3.75,'*1000 100 hiddenoffset, *1000 100 suddenoffset',e)
		if math.mod(beat,16) ~= 11 then
			highlightLine(beat+3.75,.25,0,50,inQuad,.25)
			m(beat+3.75,beat+4.25,'*1000 50 hiddenoffset, *1000 50 suddenoffset',e)
			highlightLine(beat+4.25,.5,50,0,inQuad)
			m(beat+4.25,beat+4.5,'*1000 -50 hiddenoffset, *1000 -50 suddenoffset',e)
		end
	end
	m(beat+4.5,beat+6,'*1000 0 hiddenoffset, *1000 0 suddenoffset',e)
end

scratchAlarm(142)
scratchAlarm(174)

for beat = 176,208,8 do
	me(beat,2,50,0,'stealth',l,outQuad)
	if beat ~= 208 then
		me(beat+3,2,50,0,'stealth',l,outQuad)
	end
end
for beat = 176,237 do
	if beat ~= 206 and beat ~= 207 then
		bigMini(beat,1,.2)
	end
end
for beat = 192,205 do
	me(beat,.5,0,-40,'boost',l,inQuad)
	me(beat+.5,.5,-40,0,'boost',l,outQuad)
end
for beat = 201,205,2 do
	whiteNoise(beat,.5,.25)
end

local function setRCol(pn, col)
	local pn = pn
	local col = col
	return function(v)
		rCols[pn][col] = v
	end
end

for pn = 1,2 do
	if GAMESTATE:IsPlayerEnabled(pn-1) then
		if styleName == 'double' then
			local mirrorCol = playermirror[pn] and function(col) return 9 - col end or function(col) return col end
			if diffName[pn] == 'Difficulty_Challenge' then
				me(206,0.5,0,1,setRCol(pn,mirrorCol(7)),l,outQuad)
				me(206.5,0.5,0,1,setRCol(pn,mirrorCol(4)),l,outQuad)
				me(207,1,0,1,setRCol(pn,mirrorCol(2)),l,outQuad)

				me(205.83,0.5,0,1,setRCol(pn,mirrorCol(8)),l,outQuad)
				me(206.17,0.5,0,1,setRCol(pn,mirrorCol(6)),l,outQuad)
				me(206.33,0.5,0,1,setRCol(pn,mirrorCol(5)),l,outQuad)
				me(206.75,0.75,0,1,setRCol(pn,mirrorCol(3)),l,outQuad)
				me(207.25,0.75,0,1,setRCol(pn,mirrorCol(1)),l,outQuad)
			elseif diffName[pn] == 'Difficulty_Hard' then
				me(206,0.5,0,1,setRCol(pn,mirrorCol(2)),l,outQuad)
				me(206.5,0.5,0,1,setRCol(pn,mirrorCol(4)),l,outQuad)
				me(207,1,0,1,setRCol(pn,mirrorCol(6)),l,outQuad)

				me(205.75,0.5,0,1,setRCol(pn,mirrorCol(1)),l,outQuad)
				me(206.25,0.5,0,1,setRCol(pn,mirrorCol(3)),l,outQuad)
				me(206.75,0.5,0,1,setRCol(pn,mirrorCol(5)),l,outQuad)
				me(207.25,0.75,0,1,setRCol(pn,mirrorCol(7)),l,outQuad)
				me(207.5,0.5,0,1,setRCol(pn,mirrorCol(8)),l,outQuad)
			end
		else
			local mirrorCol = playermirror[pn] and function(col) return 5 - col end or function(col) return col end
			if diffName[pn] == 'Difficulty_Challenge' then
				me(206,0.5,0,1,setRCol(pn,mirrorCol(3)),l,outQuad)
				me(206.5,0.5,0,1,setRCol(pn,mirrorCol(2)),l,outQuad)
				me(207,1,0,1,setRCol(pn,mirrorCol(4)),l,outQuad)

				me(206,2,0,1,setRCol(pn,mirrorCol(1)),l,outQuad)
			elseif diffName[pn] == 'Difficulty_Hard' then
				me(206,0.5,0,1,setRCol(pn,mirrorCol(1)),l,outQuad)
				me(206.5,0.5,0,1,setRCol(pn,mirrorCol(2)),l,outQuad)
				me(207,1,0,1,setRCol(pn,mirrorCol(3)),l,outQuad)

				me(206,2,0,1,setRCol(pn,mirrorCol(4)),l,outQuad)
			elseif diffName[pn] == 'Difficulty_Medium' then
				me(206,0.5,0,1,setRCol(pn,mirrorCol(1)),l,outQuad)
				me(206.5,0.5,0,1,setRCol(pn,mirrorCol(2)),l,outQuad)
				me(207,1,0,1,setRCol(pn,mirrorCol(4)),l,outQuad)

				me(206.5,1.5,0,1,setRCol(pn,mirrorCol(3)),l,outQuad)
			elseif diffName[pn] == 'Difficulty_Easy' then
				me(206,2,0,1,setRCol(pn,mirrorCol(3)),l,outQuad)

				me(206,1,0,1,setRCol(pn,mirrorCol(4)),l,outQuad)

				me(206.5,1.5,0,1,setRCol(pn,mirrorCol(2)),l,outQuad)
				me(207,1,0,1,setRCol(pn,mirrorCol(1)),l,outQuad)
			end
		end
	end
end
for pn = 1,2 do
	if playerspeed[pn] and diffName[pn] ~= 'Difficulty_Beginner' then
		me(207,1,50-playerscrolldir[pn]*50,150-playerscrolldir[pn]*50,'reverse',l,outQuad,pn)
		m(208,9999,'*1000000 '..(150-playerscrolldir[pn]*50)..' reverse',e,pn)
	end
end
for beat = 209,237,2 do
	whiteNoise(beat,.5,.5)
end

justTheScratch(238)

local function resetSlices()
	hslicesR[1]:croptop(0)
	hslicesR[1]:cropbottom(0)
	hslicesR[1]:x(0)
	hslicesC[1]:croptop(0)
	hslicesC[1]:cropbottom(0)
	hslicesC[1]:x(0)
	for i = 2,#hslicesR do
		hslicesR[i]:visible(false)
		hslicesC[i]:visible(false)
	end
end

local dirtySplines = true
local shrank = false

local function Update(self)
	if GAMESTATE:GetSongBeat()>=0 and not checked then
		--name players, judgment and combo
		for pn=1,2 do
			_G['P'..pn] = SCREENMAN:GetTopScreen():GetChild('PlayerP'..pn) or nil
			if _G['P'..pn] then
				_G['jud'..pn] = _G['P'..pn]:GetChild('Judgment')
				_G['com'..pn] = _G['P'..pn]:GetChild('Combo')
			end
			
		end
		
		screen = SCREENMAN:GetTopScreen()
		checked = true --let this only run once
	end

	local beat = GAMESTATE:GetSongBeat()
	
	for pn = 1,2 do
		if comboProxies[pn] then
			local p = Plr(pn)
			local c = p:GetChild('Combo')
			comboProxies[pn]:visible(Plr(pn):GetChild('Combo'):GetVisible())
		end
	end
	
	if showAFTs then
		local voffset = {}
		if #vwaves > 0 then
			for i = 0,vstripCount do
				voffset[i] = 0
				for wIndex,wave in ipairs(vwaves) do
					voffset[i] = voffset[i] + wave.amplitude * math.sin((i - vstripCount * 0.5) * wave.frequency * sw/sh + wave.offset)
				end
			end
			for fIndex,frame in ipairs(vstripFrames) do
				local skewAmt = voffset[fIndex] - voffset[fIndex - 1]
				local skewDist = (vstripCount * 0.5 - fIndex) * skewAmt
				frame:skewx(skewAmt)
				frame:x((skewDist+voffset[fIndex]) * vstripWidth)
			end
		end

		local hoffset = {}
		if #hwaves > 0 then
			for i = 0,hstripCount do
				hoffset[i] = 0
				for wIndex,wave in ipairs(hwaves) do
					hoffset[i] = hoffset[i] + wave.amplitude * math.sin((i - hstripCount * 0.5) * wave.frequency + wave.offset)
				end
			end
			for sIndex,strip in ipairs(hstrips) do
				local skewAmt = hoffset[sIndex] - hoffset[sIndex - 1]
				local skewDist = (hstripCount * 0.5 - sIndex) * skewAmt
				strip:skewx(skewAmt)
				strip:x((skewDist+hoffset[sIndex]) * hstripHeight)
			end
		end
		
		resetSlices()
		local tsp = {}
		for i = 1,2 do
			if slicePositions[i] then
				tsp[i] = { y = slicePositions[i].y, hh = slicePositions[i].hh, xr = slicePositions[i].xr, xc = slicePositions[i].xc }
				if tsp[i].hh < 0 then
					tsp[i].hh = -tsp[i].hh
				end
				if (tsp[i].xr == 0 and tsp[i].xc == 0) or (tsp[i].y + tsp[i].hh <= 0) or (tsp[i].y - tsp[i].hh >= 1) then
					tsp[i] = nil
				end
			end
		end
		if not tsp[1] then
			tsp[1] = tsp[2]
			tsp[2] = nil
		end
		
		if tsp[1] then
			if tsp[2] then
				local endpoints = { 0, tsp[1].y-tsp[1].hh, tsp[1].y+tsp[1].hh, tsp[2].y-tsp[2].hh, tsp[2].y+tsp[2].hh, 1 }
				table.sort(endpoints)
				while endpoints[1] < 0 do
					table.remove(endpoints,1)
				end
				while endpoints[#endpoints] > 1 do
					endpoints[#endpoints] = nil
				end
				for i = 1,#endpoints-1 do
					hslicesR[i]:croptop(endpoints[i])
					hslicesC[i]:croptop(endpoints[i])
					hslicesR[i]:cropbottom(1-endpoints[i+1])
					hslicesC[i]:cropbottom(1-endpoints[i+1])
					local xr = 0
					local xc = 0
					for j = 1,2 do
						if (endpoints[i] >= tsp[j].y - tsp[j].hh) and (endpoints[i+1] <= tsp[j].y + tsp[j].hh) then
							xr = xr + tsp[j].xr
							xc = xc + tsp[j].xc
						end
					end
					hslicesR[i]:x(xr*sh)
					hslicesC[i]:x(xc*sh)
					hslicesR[i]:visible(true)
					hslicesC[i]:visible(true)
				end
			else
				if tsp[1].y - tsp[1].hh <= 0 then
					if tsp[1].y + tsp[1].hh >= 1 then
						hslicesR[1]:x(tsp[1].x * sh)
						hslicesC[1]:x(-tsp[1].x * sh)
					else
						hslicesR[1]:cropbottom(1-(tsp[1].y+tsp[1].hh))
						hslicesR[1]:x(tsp[1].xr * sh)
						hslicesC[1]:cropbottom(1-(tsp[1].y+tsp[1].hh))
						hslicesC[1]:x(tsp[1].xc * sh)
						
						hslicesR[2]:croptop(tsp[1].y+tsp[1].hh)
						hslicesR[2]:cropbottom(0)
						hslicesR[2]:x(0)
						hslicesR[2]:visible(true)
						hslicesC[2]:croptop(tsp[1].y+tsp[1].hh)
						hslicesC[2]:cropbottom(0)
						hslicesC[2]:x(0)
						hslicesC[2]:visible(true)
					end
				elseif tsp[1].y + tsp[1].hh <= 1 then
					hslicesR[1]:cropbottom(1-(tsp[1].y-tsp[1].hh))
					hslicesC[1]:cropbottom(1-(tsp[1].y-tsp[1].hh))
					
					hslicesR[2]:croptop(tsp[1].y-tsp[1].hh)
					hslicesR[2]:cropbottom(1-(tsp[1].y+tsp[1].hh))
					hslicesR[2]:x(tsp[1].xr * sh)
					hslicesR[2]:visible(true)
					hslicesC[2]:croptop(tsp[1].y-tsp[1].hh)
					hslicesC[2]:cropbottom(1-(tsp[1].y+tsp[1].hh))
					hslicesC[2]:x(tsp[1].xc * sh)
					hslicesC[2]:visible(true)
					
					hslicesR[3]:croptop(tsp[1].y+tsp[1].hh)
					hslicesR[3]:cropbottom(0)
					hslicesR[3]:x(0)
					hslicesR[3]:visible(true)
					hslicesC[3]:croptop(tsp[1].y+tsp[1].hh)
					hslicesC[3]:cropbottom(0)
					hslicesC[3]:x(0)
					hslicesC[3]:visible(true)
				elseif tsp[1].y - tsp[1].hh <= 1 then
					hslicesR[1]:cropbottom(1-(tsp[1].y-tsp[1].hh))
					hslicesC[1]:cropbottom(1-(tsp[1].y-tsp[1].hh))
					
					hslicesR[2]:croptop(tsp[1].y-tsp[1].hh)
					hslicesR[2]:cropbottom(0)
					hslicesR[2]:x(tsp[1].xr * sh)
					hslicesR[2]:visible(true)
					hslicesC[2]:croptop(tsp[1].y-tsp[1].hh)
					hslicesC[2]:cropbottom(0)
					hslicesC[2]:x(tsp[1].xc * sh)
					hslicesC[2]:visible(true)
				end
			end
		end
	end
	
	if beat > 111.5 and beat < 174.5 then
		local incycle = beat % 16
		local nextbreak
		local closesize = 1
		local autoreverse = 1
		if incycle <= 1.5 then
			nextbreak = 2.5 - incycle
			if beat >= 144 and beat <= 163 then
				nextbreak = nextbreak - 0.25
			end
		elseif (beat < 144 or beat > 163) and incycle < 2.5 then
			nextbreak = 2.5 - incycle
			closesize = nextbreak
		elseif incycle < 2.25 then
			nextbreak = 2.25 - incycle
			closesize = nextbreak * 4/3
		elseif (beat < 144 or beat > 163) and incycle < 2.625 then
			autoreverse = -1
			nextbreak = -1
			closesize = (incycle - 2.5) * 8
		elseif incycle < 2.375 then
			autoreverse = -1
			nextbreak = -1
			closesize = (incycle - 2.25) * 8
		elseif incycle <= 9.5 then
			autoreverse = -1
			nextbreak = 10.5 - incycle
			if beat >= 144 and beat <= 163 then
				nextbreak = nextbreak - 0.25
			end
		elseif (beat < 144 or beat > 163) and incycle < 10.5 then
			autoreverse = -1
			nextbreak = 10.5 - incycle
			closesize = nextbreak
		elseif incycle < 10.25 then
			autoreverse = -1
			nextbreak = 10.25 - incycle
			closesize = nextbreak * 4/3
		elseif (beat < 144 or beat > 163) and incycle < 10.625 then
			nextbreak = -1
			closesize = (incycle - 10.5) * 8
		elseif incycle < 10.375 then
			nextbreak = -1
			closesize = (incycle - 10.25) * 8
		else
			nextbreak = 18.5 - incycle
			if beat >= 144 and beat <= 163 then
				nextbreak = nextbreak - 0.25
			end
		end
		for pn=1,2 do
			local plr = SCREENMAN:GetTopScreen():GetChild('PlayerP'..pn)
			if plr and diffName[pn] ~= 'Difficulty_Beginner' then
				local nf = plr:GetChild('NoteField')
				for col = 1,8 do
					local ca = nf:GetColumnActors()[col]
					if ca then
						ca:GetPosHandler():SetSplineMode('NoteColumnSplineMode_Position')
						ca:GetPosHandler():SetBeatsPerT(0.125)
						ca:GetZoomHandler():SetSplineMode('NoteColumnSplineMode_Position')
						ca:GetZoomHandler():SetBeatsPerT(0.125)
						local pspl = ca:GetPosHandler():GetSpline()
						local zspl = ca:GetZoomHandler():GetSpline()
						local size = math.round(7.5*8/(playerspeed[pn]*playerminisize[pn]))
						pspl:SetSize(size)
						zspl:SetSize(size)
						local alreadybroke = false
						local currentsize = closesize
						local totalscrolldir = playerscrolldir[pn] * autoreverse
						for point=1,size do
							pspl:SetPoint(point, {64*(col-centerCol)*currentsize, (-135/playerminisize[pn]+8*(point-1)*playerspeed[pn])*totalscrolldir, 0} )
							zspl:SetPoint(point, {currentsize * values.baseArrowSize, currentsize * values.baseArrowSize, currentsize * values.baseArrowSize} )
							if (point-1)*.125 > nextbreak and not alreadybroke then
								currentsize = 1
								if nextbreak >= 0 then
									totalscrolldir = -totalscrolldir
								end
								alreadybroke = true
							end
						end
						pspl:Solve()
						zspl:Solve()
					end
				end
			end
		end
	elseif beat >= 205.75 and beat < 208 then
		dirtySplines = true
		for pn=1,2 do
			local plr = SCREENMAN:GetTopScreen():GetChild('PlayerP'..pn)
			if plr then
				local nf = plr:GetChild('NoteField')
				for col = 1,8 do
					local ca = nf:GetColumnActors()[col]
					if ca then
						ca:GetPosHandler():SetSplineMode('NoteColumnSplineMode_Position')
						ca:GetPosHandler():SetBeatsPerT(16)
						local pspl = ca:GetPosHandler():GetSpline()
						pspl:SetSize(2)
						local totalscrolldir = playerscrolldir[pn] - 2 * rCols[pn][col] * playerscrolldir[pn]
						pspl:SetPoint(1, { 64*(col-centerCol), (-135/playerminisize[pn])*totalscrolldir, 0} )
						pspl:SetPoint(2, { 64*(col-centerCol), (-135/playerminisize[pn]+1024*playerspeed[pn])*totalscrolldir, 0} )
						pspl:Solve()
					end
				end
			end
		end
	elseif beat >= 174.5 and dirtySplines then
		for pn=1,2 do
			local plr = SCREENMAN:GetTopScreen():GetChild('PlayerP'..pn)
			if plr then
				local nf = plr:GetChild('NoteField')
				for col = 1,8 do
					local ca = nf:GetColumnActors()[col]
					if ca then
						ca:GetPosHandler():SetSplineMode('NoteColumnSplineMode_Disabled')
						ca:GetZoomHandler():SetSplineMode('NoteColumnSplineMode_Disabled')
					end
				end
			end
		end
		dirtySplines = false
	end
	if beat >= 238.5 and not shrank then
		for pn = 1,2 do
			if pp[pn] then
				pp[pn]:accelerate(.25*60/110)
				pp[pn]:zoom(0)
			end
		end
		shrank = true
	end

---------------------------------------------------------------------------------------
----------------------Begin table handlers---------------------------------------------
---------------------------------------------------------------------------------------
	
	disable = false
	if disable ~= true and beat > mod_firstSeenBeat+0.1 and checked then
		
		-----------------------
		-- Player mod resets --
		-----------------------
		for i=1,2 do
			--mod_do('clearall',i)
		end
		
		------------------------------------------------------------------------------
		-- custom mod reader by TaroNuke edited by WinDEU and re-stolen by TaroNuke --
		------------------------------------------------------------------------------
		for i,v in pairs(mods) do
			if v and table.getn(v) > 3 and v[1] and v[2] and v[3] and v[4] then
				if beat >=v[1] then
					if (v[4] == 'len' and beat <=v[1]+v[2]) or (v[4] == 'end' and beat <=v[2]) then
						if table.getn(v) == 5 then
							mod_do(v[3],v[5])
						else
							mod_do(v[3])
						end
					end
				end
			else
				v[1] = 0
				v[2] = 0
				v[3] = ''
				v[4] = 'error'
				SCREENMAN:SystemMessage('Bad mod in beat-based table (line '..i..')')
			end
		end
		
		--------------------------------------------------------------------------------------
		-- i dont know who this reader is but he looks like he is made out of EASE HAHAHAHA --
		-- original code by exschwasion, bastardized by taro for cmod support and less 'if' --
		--------------------------------------------------------------------------------------
		for i,v in pairs(mods_ease) do
			if v and table.getn(v) > 6 and v[1] and v[2] and v[3] and v[4] and v[5] and v[6] and v[7] then
				if beat >=v[1] then
					local mod = v[5]
					if (v[6] == 'len' and beat <=v[1]+v[2]) or (v[6] == 'end' and beat <=v[2]) then
						
						local duration = v[2]
						if v[6] == 'end' then duration = v[2] - v[1] end
						local curtime = beat - v[1]
						local diff = v[4] - v[3]
						local startstrength = v[3]
						local curve = v[7]
						
						local strength = curve(curtime, startstrength, diff, duration, v[10], v[11]) --extra parameters for back and elastic eases :eyes:
						
						if type(mod) == 'function' then
							mod(strength)
						else
							local modstr = v[5] == 'xmod' and strength..'x' or (v[5] == 'cmod' and 'C'..strength or strength..' '..v[5])
							mod_do('*10000 '..modstr,v[8]);
						end
						
					elseif (v[9] and ((v[6] == 'len' and beat <=v[1]+v[2]+v[9]) or (v[6] == 'end' and beat <=v[9]))) then
						local strength = v[4]
						if type(mod) == 'function' then
							mod(strength)
						else
							local modstr = v[5] == 'xmod' and strength..'x' or (v[5] == 'cmod' and 'C'..strength or strength..' '..v[5])
							mod_do('*10000 '..modstr,v[8]);
						end
						
					end
				end
			else
				SCREENMAN:SystemMessage('Bad mod in beat-based ease table (line '..i..')')
			end
		end
		
		--------------------
		-- Perframe stuff --
		--------------------
		
		----------------------------------------
		-- HBLBHCBLBJGBHL DO THIS EVERY FRAME --
		----------------------------------------
		
		if table.getn(mod_perframes)>0 then
			for i=1,table.getn(mod_perframes) do
				local a = mod_perframes[i]
				if beat > a[1] and beat < a[2] then
					a[3](beat)
				end
			end
		end
		
		---------------------------------------
		-- ACTION RPGS AINT GOT SHIT ON THIS --
		---------------------------------------
		while curaction<=table.getn(mod_actions) and GAMESTATE:GetSongBeat()>=mod_actions[curaction][1] do
			if mod_actions[curaction][3] or GAMESTATE:GetSongBeat() < mod_actions[curaction][1]+2 then
				if type(mod_actions[curaction][2]) == 'function' then
					mod_actions[curaction][2]()
				elseif type(mod_actions[curaction][2]) == 'string' then
					MESSAGEMAN:Broadcast(mod_actions[curaction][2])
				end
			end
			curaction = curaction+1
		end
		
	end
	
---------------------------------------------------------------------------------------
----------------------END DON'T TOUCH IT KIDDO-----------------------------------------
---------------------------------------------------------------------------------------
	
end

local t = Def.ActorFrame{
	InitCommand=function(self)
		self:x(scx)
		self:y(scy)
		self:SetUpdateFunction(Update)
	end,
	Def.Quad{ InitCommand= cmd(visible,false), OnCommand= cmd(sleep,1000), },
}
if showAFTs then
	aft_screenTex = Def.ActorFrameTexture{
		Name = "ScreenTex",
		InitCommand=function(self)
			self:SetTextureName( "ScreenTex" )
			self:SetWidth(dw);
			self:SetHeight(dh);
			self:EnableAlphaBuffer(false);
			self:Create();
		end,
		OnCommand=function(self)
			self:visible(true);
			self:Draw();
		end,
		Def.Quad{ OnCommand=cmd(x,dw*0.5;y,dh*0.5;zoomto,dw,dh;diffuse,0,0,0,1), },
		LoadActor("../7th background.png")..{
			OnCommand=cmd(x,dw*0.5;y,dh*0.5;zoomto,dw,dh;diffuse,1,1,1,PREFSMAN:GetPreference('BGBrightness')),
		},
		Def.ActorProxy{ Name = "ProxyUL"; OnCommand=function(self) self:x(0); self:y(0) self:SetTarget(SCREENMAN:GetTopScreen():GetChild('Underlay')); self:zoom(rz); end },
		Def.ActorFrame{
			Name = "FrameProxyP1";
			OnCommand=function(self)
				local p = SCREENMAN:GetTopScreen():GetChild('PlayerP1')
				if p then
					self:x(p:GetX()/sw*dw);
					self:y(dh*.5);
				end
			end,
			Def.ActorProxy{ Name = "ProxyP1C"; OnCommand=function(self)
				self:x(0);
				self:y(0);
				self:zoom(rz);
				local p = SCREENMAN:GetTopScreen():GetChild('PlayerP1');
				if p then
					self:SetTarget(p:GetChild('Combo'));
					comboProxies[1] = self;
				end
			end },
			Def.ActorProxy{ Name = "ProxyP1N"; OnCommand=function(self)
				self:x(0);
				self:y(0);
				self:zoom(rz);
				local p = SCREENMAN:GetTopScreen():GetChild('PlayerP1');
				if p then
					self:SetTarget(p:GetChild('NoteField'));
					pp[1] = self;
				end
			end },
			Def.ActorProxy{ Name = "ProxyP1J"; OnCommand=function(self)
				self:x(0);
				self:y(0);
				self:zoom(rz);
				local p = SCREENMAN:GetTopScreen():GetChild('PlayerP1');
				if p then
					self:SetTarget(p:GetChild('Judgment'));
				end
			end }
		},
		Def.ActorFrame{
			Name = "FrameProxyP2";
			OnCommand=function(self)
				local p = SCREENMAN:GetTopScreen():GetChild('PlayerP2')
				if p then
					self:x(p:GetX()/sw*dw);
					self:y(dh*.5);
				end
			end,
			Def.ActorProxy{ Name = "ProxyP2C"; OnCommand=function(self)
				self:x(0);
				self:y(0);
				self:zoom(rz);
				local p = SCREENMAN:GetTopScreen():GetChild('PlayerP2');
				if p then
					self:SetTarget(p:GetChild('Combo'));
					comboProxies[2] = self;
				end
			end },
			Def.ActorProxy{ Name = "ProxyP2N"; OnCommand=function(self)
				self:x(0);
				self:y(0);
				self:zoom(rz);
				local p = SCREENMAN:GetTopScreen():GetChild('PlayerP2');
				if p then
					self:SetTarget(p:GetChild('NoteField'));
					pp[2] = self;
				end
			end },
			Def.ActorProxy{ Name = "ProxyP2J"; OnCommand=function(self)
				self:x(0);
				self:y(0);
				self:zoom(rz);
				local p = SCREENMAN:GetTopScreen():GetChild('PlayerP2');
				if p then
					self:SetTarget(p:GetChild('Judgment'));
				end
			end },
		},
		Def.ActorProxy{ Name = "ProxyOL"; OnCommand=function(self) self:x(0); self:y(0) self:SetTarget(SCREENMAN:GetTopScreen():GetChild('Overlay')); self:zoom(rz); end },
	};
	t[#t+1] = aft_screenTex
	aft_vStripsTex = Def.ActorFrameTexture{
		Name = "VStripsTex",
		InitCommand=function(self)
			self:SetTextureName( "VStripsTex" )
			self:SetWidth(dw);
			self:SetHeight(dh);
			self:EnableAlphaBuffer(true);
			self:Create();
		end,
		OnCommand=function(self)
			self:visible(true);
			self:Draw();
		end,
	};
	for i = 1,vstripCount do
		local i = i
		aft_vStripsTex[#aft_vStripsTex+1]=Def.ActorFrame{
			Name = "VStripOuterFrame"..i,
			OnCommand = cmd(rotationz,-90;x,dw*0.5;y,dh*0.5),
			Def.ActorFrame{
				Name = "VStripInnerFrame"..i,
				InitCommand = function(self)
					vstripFrames[i] = self;
				end,
				Def.Sprite{
					Name = "VStrip"..i;
					Texture = "ScreenTex";
					InitCommand=function(self)
						vstrips[i] = self;
					end,
					OnCommand=function(self)
						self:rotationz(90)
						self:cropleft((i-1)/(vstripCount))
						self:cropright((vstripCount-i)/(vstripCount))
						self:visible(true);
					end,
				};
			};
		};
	end
	t[#t+1] = aft_vStripsTex
	local hStripsInnerFrame = Def.ActorFrame{ OnCommand = cmd(x,dw*0.5;y,dh*0.5), }
	for i = 1,hstripCount do
		local i = i
		hStripsInnerFrame[#hStripsInnerFrame + 1] = Def.Sprite{
			Name = "HStrip"..i;
			Texture = "VStripsTex";
			OnCommand=function(self)
				self:croptop((i-1)/hstripCount)
				self:cropbottom((hstripCount-i)/hstripCount)
				self:visible(true);
				hstrips[i] = self;
			end,
		};
	end
	aft_hStripsTex = Def.ActorFrameTexture{
		Name = "HStripsTex",
		InitCommand=function(self)
			self:SetTextureName( "HStripsTex" )
			self:SetWidth(dw);
			self:SetHeight(dh);
			self:EnableAlphaBuffer(true);
			self:Create();
		end,
		OnCommand=function(self)
			self:visible(true);
			self:Draw();
		end,
		hStripsInnerFrame,
	};
	t[#t+1] = aft_hStripsTex
	t[#t+1] = Def.Quad{ OnCommand=cmd(zoomto,SCREEN_WIDTH,SCREEN_HEIGHT;diffuse,0,0,0,1), }
	for i = 1,hsliceCount*2+1 do
		local rs = Def.Sprite{
			Name = "HSliceR"..i,
			Texture = "HStripsTex",
			InitCommand=function(self)
				table.insert(hslicesR,self);
			end,
			OnCommand=function(self)
				self:diffuse(1,0,0,1);
				self:zoom(zr);
				self:visible(true);
			end,
		};
		local cs = Def.Sprite{
			Name = "HSliceC"..i,
			Texture = "HStripsTex",
			InitCommand=function(self)
				table.insert(hslicesC,self);
			end,
			OnCommand=function(self)
				self:diffuse(0,1,1,1);
				self:zoom(zr);
				self:blend('add');
				self:visible(true);
			end,
		};
		t[#t+1] = rs
		t[#t+1] = cs
	end
end

return t